/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Puzzle
**
** DESCRIPTION:	Maintains completion status of puzzles
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef PUZZLE_H
#define PUZZLE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "PuzzleInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EPuzzle
{
	// Essential puzzles
	ePuzzle_Chief = 0,
	ePuzzle_BeeHive,
	ePuzzle_AlchemyLab,
	ePuzzle_RosterOfTheDead,
	ePuzzle_WeatherDance,
	ePuzzle_RainLift,
	ePuzzle_Ruins,
	ePuzzle_Bath,
	ePuzzle_PrincessStatue,
	ePuzzle_Orchard,
	ePuzzle_SharkCharmer,
	ePuzzle_Aromatherapy,
	ePuzzle_FireKey,
	ePuzzle_TreeKey,
	ePuzzle_ClamKey,
	ePuzzle_SunDisk,

	ePuzzle_NumberOfEssential,	

	// Additional puzzles
	ePuzzle_AlchemyPot = ePuzzle_NumberOfEssential,
	ePuzzle_AlchemyTable,
	ePuzzle_ChalkBoard,
	ePuzzle_DoorKey,
	ePuzzle_FirePit,
	ePuzzle_House1Construction,
	ePuzzle_House2Construction,
	ePuzzle_House3Construction,
	ePuzzle_ClothingHutConstruction,
	ePuzzle_HospitalConstruction,

	ePuzzle_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CPuzzle
{
private:

	//class structures
	struct SPuzzle
	{
		int				m_iPoints;
		unsigned int	m_uiCompletionTime;
	};

	//class data
	static const int	scm_iPointsRequired[ePuzzle_NumberOf];
	static IPuzzle *	sm_pPuzzle[ePuzzle_NumberOf];

	SPuzzle				m_sPuzzle[ePuzzle_NumberOf];

	IPuzzle *			m_pModule[ePuzzle_NumberOf];
	int					m_iNumModules;

	//class methods
	//setup
	public:		CPuzzle(void);
	public:		void Reset();
	public:		void Reset(const EPuzzle ePuzzle);
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int GetPuzzleStateSize() const;
	public:		const bool LoadState(const unsigned char *pData);
	public:		const bool SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh() const;
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Advance(const EPuzzle ePuzzle, CVillager &Villager, const int iRef);

	// access
	public:		void IncrementProgress(const EPuzzle ePuzzle);
	public:		void DecrementProgress(const EPuzzle ePuzzle);
	public:		const bool IsComplete(const EPuzzle ePuzzle) const;
	public:		const int PercentComplete(const EPuzzle ePuzzle) const;
	public:		const int PuzzlesComplete() const;
	public:		const int EssentialPuzzlesComplete() const;
	public:		const int CompletionTime(const EPuzzle ePuzzle) const;
	public:		const int PointsRemaining(const EPuzzle ePuzzle) const;
	public:		void SetPointsRemaining(const EPuzzle ePuzzle, const int iPointsRemaining);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CPuzzle		Puzzle;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/